function normal = calculateNormalToPlane(points3D)
    % Extract three points from the plane
    p1 = points3D(1, :);
    p2 = points3D(2, :);
    p3 = points3D(3, :);

    % Calculate two vectors lying on the plane
    vector1 = p2 - p1;
    vector2 = p3 - p1;

    % Calculate the cross product, which is perpendicular to the plane
    normalVector = cross(vector1, vector2);

    % Normalize the normal vector
    normalLength = sqrt(sum(normalVector.^2));
    normal = normalVector / normalLength;
end